package editor;

import game.CustomImageDataII;
import game.IntRect;
import game.RainbowElementalSprite;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.image.ImageObserver;

public class RainbowBossScreenPaletteObject extends ScreenPaletteObject {
	
	
	private RoomEditorPanel editorPanel;
	
	private RainbowBossScreenObject createdObject;
	
	private boolean settingFlagPos = false;
	
	public RainbowBossScreenPaletteObject(IntRect theClickRect, int theDistanceToBorder, int theBorderWidth, ImageObserver io, RoomEditorPanel thePanel) {
		
		clickRect = theClickRect;
		
		image = new CustomImageDataII("/images/elemental_icon_boss.GIF", Color.black, io);
		
		distanceToBorder = theDistanceToBorder;
		borderWidth = theBorderWidth;
		editorPanel = thePanel;
	} 
	
	
	
	
	@Override
	public ScreenObject create(int x, int y, ImageObserver io) {
		if(editorPanel.doesRainbowElementalAlreadyExist()) {
			
//			System.err.println("According to this, the rainbow boss already exists!  let's see where... oh, it wanted me to spawn at x: " + x + ", y:" + y );
			
//			RainbowBossScreenObject bossSO = editorPanel.getBoss();
			
//			System.err.println("So...is the boss null? " + (bossSO) == null);
			
//			if(bossSO != null) {
//				System.err.println("so...where IS it?  " 
//							+ bossSO.getClickRect().getCenter().x 
//							+ ", " + bossSO.getClickRect().getCenter().y);
//			}
			
			
			return null;
		}
		createdObject =  new RainbowBossScreenObject(x, y, io, RainbowElementalSprite.NO_SPAWNING, this);
		return createdObject;
	}

	@Override
	public void draw(Graphics g) {
		if(clickRect == null)
			return;
		
		Point p = clickRect.getCenter();
		
		image.drawObjectFromUpperLeftCorner(g, clickRect.getMinX(),clickRect.getMinY());
		
		Color origCol = g.getColor();
		
		if(isSelected) {
			g.setColor(new Color(255, 200, 0));
		} else {
			g.setColor(new Color(100, 100, 100));
		}
		
		for(int i = 0; i < borderWidth; i++) {
			g.drawRect(clickRect.getMinX() - (distanceToBorder + i), clickRect.getMinY() - (distanceToBorder + i), clickRect.width() + (distanceToBorder + i) * 2, clickRect.height() + (distanceToBorder + i) * 2);
		}
		
		
		g.setColor(origCol);
	}




	@Override
	public void delete(ScreenObject so) {
		// TODO Auto-generated method stub
		
	}




	public boolean isSettingFlagPos() {
		return settingFlagPos;
	}




	public void setSettingFlagPos(boolean settingFlagPos) {
		this.settingFlagPos = settingFlagPos;
	}
	
	public void screenObjectDeleted() {
		createdObject = null;
	}
	
	public RainbowBossScreenObject getCreatedObject() {
		return createdObject;
	}
	

}
